/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * sst_prim.h                                                          *
   * Christian Zurhorst, BVS R&D, 29. Jul. 1998                          *
   *                                                                     *
   * SST primiteves                                                      *
   *                                                                     *
   ***********************************************************************
*/


#ifndef __SST_PRIM_H
#define __SST_PRIM_H

#include "sstdefs.h"


#define B_SST_RPT_MAXSIZE      256


#ifdef __cplusplus
extern "C" {
#endif


b_errtype EXPORT BestSstPrimRun (b_handletype handle);
b_errtype EXPORT BestSstPrimContinue (b_handletype handle);
b_errtype EXPORT BestSstPrimStop (b_handletype handle);
b_errtype EXPORT BestSstPrimPause (b_handletype handle);
b_errtype EXPORT BestSstPrimAbort (b_handletype handle);
b_errtype EXPORT BestSstPrimFinished (b_handletype handle);

b_errtype EXPORT BestSstReportStore (b_handletype handle, void *report);
b_errtype EXPORT BestSstReportRecall (b_handletype handle, void *report);

b_errtype EXPORT BestSstResultRead (b_handletype handle, void *rpt_result);
b_errtype EXPORT BestSstResultWrite (b_handletype handle, void *rpt_result);

b_errtype EXPORT BestSstPrimPresent (b_handletype handle, b_int32 *value);

b_errtype EXPORT BestSstStatusGet (
  b_handletype handle, 
  b_sststatustype status, 
  b_int32 *value
  );

b_errtype EXPORT BestSstElapsedTime (b_handletype handle, b_int32 *value);

#ifdef __cplusplus
}
#endif

#endif


